#!/bin/sh
#
# Opennet Firmware
# 
# Copyright 2010 Rene Ejury <opennet@absorb.it>
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#   http://www.apache.org/licenses/LICENSE-2.0
# 

#################################################################################
# just to get the IP for gateways only registered by name
# parameter is name
query_dns() { nslookup $1 2>/dev/null | tail -n 1 | awk '{ print $3 }'; }

query_dns_reverse() { nslookup $1 2>/dev/null | tail -n 1 | awk '{ print $4 }'; }

get_network() { 
    ipaddr=$(ip address show label $(uci -q get network.$1.ifname) | awk '/inet/ {print $2; exit}')
    [ -z "$ipaddr" ] || { eval $(ipcalc -p -n $ipaddr); echo $NETWORK/$PREFIX; }
}

check_firmware_upgrade() {
	old_version=$(awk '{if (/opennet-firmware-ng/) print $4}' /etc/banner)
	cur_version=$(opkg status on-core | awk '{if (/Version/) print $2;}')
	if [ "$old_version" != "$cur_version" ]; then
		copy_etc_presets;
		add_banner;
	fi
}

copy_etc_presets() {
	ln -sf /etc/etc_presets/passwd /etc/passwd
	ln -sf /etc/etc_presets/rc.local /etc/rc.local
	ln -sf /etc/etc_presets/watchdog /etc/init.d/watchdog
}

copy_config_presets() {
    for preset in /etc/config_presets/*; do
		if [ "$1" == "force" ]; then
			cp $preset /etc/config/${preset#/*/*/};
		else
			[ -f /etc/config/${preset#/*/*/} ] || cp $preset /etc/config/${preset#/*/*/};
		fi
    done
}

add_banner() {
	version=$(opkg status on-core | awk '{if (/Version/) print $2;}')
    version_line=" ---- with opennet-firmware-ng "$version" "
    empty_line=" "
    while [ ${#version_line} -lt 52 ]; do version_line="$version_line-"; done
    while [ ${#empty_line} -lt 52 ]; do empty_line="$empty_line-"; done

    awk '
        BEGIN{ tagged=0 }
        {
            if ($0 ~ /opennet-firmware/) {
                tagged=1; print "'"$version_line"'";
            }
            else print $0
        }
        END{ if (tagged == 0) print "'"$version_line"'\n'"$empty_line"'"}' /etc/banner >/tmp/banner

    mv /tmp/banner /etc/banner
}
