--[[
Opennet Firmware

Copyright 2010 Rene Ejury <opennet@absorb.it>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

$Id: opennet.lua 5485 2009-11-01 14:24:04Z jow $
]]--
module("luci.controller.opennet.on_gateways", package.seeall)

function index()
	luci.i18n.loadc("on_base")
	local i18n = luci.i18n.translate
	
	local page  = entry({"opennet", "opennet_2", "vpn_gateways"}, call("action_vpn_gateways"), i18n("on_gateways"), 1)
	page.i18n    = "on_gateways"
	page.css     = "opennet.css"
end

function action_vpn_gateways()
	local uci = require "luci.model.uci"
	local cursor = uci.cursor()
		
	function move_gateway_down (number)
		local t_below = cursor:get_all("on-openvpn", "gate_"..(number + 1))
		local t_current = cursor:get_all("on-openvpn", "gate_"..number)
		cursor:tset ("on-openvpn", "gate_"..(number + 1), t_current)
		cursor:tset ("on-openvpn", "gate_"..number, t_below)
-- 		reordering can't be done with model.uci, so we do it in the shell
		os.execute("uci reorder on-openvpn.gate_"..number.."="..(number-1))
	end

	
	local new_gateway = luci.http.formvalue("new_gateway")
	local new_gateway_name = luci.http.formvalue("new_gateway_name")
	local new_blacklist_gateway = luci.http.formvalue("new_blacklist_gateway")
	local new_blacklist_gateway_name = luci.http.formvalue("new_blacklist_gateway_name")
	local toggle_gateway_search = luci.http.formvalue("toggle_gateway_search")
	local toggle_sort_criteria = luci.http.formvalue("toggle_sort_criteria")
	local del_section = luci.http.formvalue("del_section")
	local del_blacklist_gw = luci.http.formvalue("del_blacklist_gw")
	local down_section = luci.http.formvalue("down_section")
	local reset_counter = luci.http.formvalue("reset_counter")
	local number_of_gateways = 0
	cursor:foreach ("on-openvpn", "gateway", function() number_of_gateways = number_of_gateways + 1 end)
	
	if (new_gateway and new_gateway ~= "") or (new_gateway_name and new_gateway_name ~= "") then
		cursor:set ("on-openvpn", "gate_"..(number_of_gateways + 1), "gateway")
		cursor:tset ("on-openvpn", "gate_"..(number_of_gateways + 1), { ipaddr = new_gateway, name = new_gateway_name, age = '', status = '', route = ''})
	elseif (new_blacklist_gateway and new_blacklist_gateway ~= "") or (new_blacklist_gateway_name and new_blacklist_gateway_name ~= "") then
		cursor:section("on-openvpn", "blacklist_gateway", nil, { ipaddr = new_blacklist_gateway, name = new_blacklist_gateway_name })
	elseif down_section then
		down_section = down_section + 0
		move_gateway_down(down_section)
	elseif toggle_gateway_search then
		local search = cursor:get("on-openvpn", "gateways", "autosearch")
		if search == "on" then search = "off" else search = "on" end
		cursor:set("on-openvpn", "gateways", "autosearch", search)
	elseif toggle_sort_criteria then
		local sort = cursor:get("on-openvpn", "gateways", "vpn_sort_criteria")
		if sort == "etx" then sort = "metric" else sort = "etx" end
		cursor:set("on-openvpn", "gateways", "vpn_sort_criteria", sort)
	elseif del_section then
		while ((del_section + 0) < number_of_gateways) do	-- comparising failed if del_section wasn't forced to be int
			move_gateway_down(del_section)
			del_section = del_section + 1
		end
		cursor:delete("on-openvpn", "gate_"..del_section)
	elseif del_blacklist_gw	then
		cursor:delete("on-openvpn", del_blacklist_gw)
	elseif reset_counter then
		for k, v in pairs(cursor:get_all("on-openvpn")) do
			if v[".type"] == "gateway" then cursor:set("on-openvpn", k, "age", "") end
		end
	end
	if new_gateway or new_gateway_name or new_blacklist_gateway or new_blacklist_gateway_name or del_section or toggle_gateway_search or toggle_sort_criteria or reset_counter then
		cursor:commit("on-openvpn")
		cursor:unload("on-openvpn")	-- just to get the real values for del-buttons
	end

	show_more_info = luci.http.formvalue("show_more_info")
	
	luci.template.render("opennet/on_gateways", { show_more_info = show_more_info })
end
