--[[
Opennet Firmware

Copyright 2010 Rene Ejury <opennet@absorb.it>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

$Id: opennet.lua 5485 2009-11-01 14:24:04Z jow $
]]--
module("luci.controller.opennet.on_openvpn", package.seeall)

function index()
	luci.i18n.loadc("on_base")
	local i18n = luci.i18n.translate
	
	local page = entry({"opennet", "opennet_1", "vpn_tunnel"}, call("action_on_openvpn"), i18n("on_vpn"), 2)
	page.i18n    = "on_openvpn"
	page.css     = "opennet.css"
end

function action_on_openvpn()
	require ("luci.model.opennet.on_vpn_management")
	
	if luci.http.formvalue("restartvpn") then os.execute("/etc/init.d/openvpn down opennet_user; /etc/init.d/openvpn down opennet_user") end
	
	if luci.http.formvalue("upload") then upload_file("user") end
	
	local download = luci.http.formvalue("download")
	if download then download_file("user", download) end
	
	local openssl = {}
	fill_openssl("on-openvpn", openssl)
	if luci.http.formvalue("generate") then generate_csr("user", openssl) end
	
	local SYSROOT = os.getenv("LUCI_SYSROOT")
	if not SYSROOT then SYSROOT = "" end		-- SYSROOT is only used for local testing (make runhttpd in luci tree)
	local on_csr_exists = nixio.fs.access(SYSROOT.."/etc/openvpn/opennet_user/on_aps.csr")
	local on_key_exists = nixio.fs.access(SYSROOT.."/etc/openvpn/opennet_user/on_aps.key")
	local on_crt_exists = nixio.fs.access(SYSROOT.."/etc/openvpn/opennet_user/on_aps.crt")
	local tunnel_active = nixio.fs.access(SYSROOT.."/tmp/openvpn_msg.txt")
	local force_show_uploadfields = luci.http.formvalue("force_show_uploadfields")
	local force_show_generatefields = luci.http.formvalue("force_show_generatefields")

	luci.template.render("opennet/on_openvpn", {
		tunnel_active=tunnel_active, on_csr_exists=on_csr_exists,on_key_exists=on_key_exists, on_crt_exists=on_crt_exists,
		openssl=openssl, force_show_uploadfields=force_show_uploadfields, force_show_generatefields=force_show_generatefields
		})
end
