--[[
Opennet Firmware

Copyright 2010 Rene Ejury <opennet@absorb.it>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

$Id: opennet.lua 5485 2009-11-01 14:24:04Z jow $
]]--
module("luci.controller.opennet.on_usergw", package.seeall)

function index()
	luci.i18n.loadc("on_base")
	local i18n = luci.i18n.translate
	
	local page = entry({"opennet", "opennet_2", "ugw_tunnel"}, call("action_on_usergw"), i18n("on_usergw"), 3)
	page.css = "opennet.css"
	page.i18n = "on_usergw"
end

function action_on_usergw()
	require ("luci.model.opennet.on_vpn_management")
	
    local uci = require "luci.model.uci"
    local cursor = uci.cursor()
    
    if luci.http.formvalue("disable_sharing") then
        cursor:set("on-usergw", "ugw_sharing", "shareInternet", "off")
        os.execute("/usr/sbin/on_usergateway_check shareInternet &")
    elseif luci.http.formvalue("enable_sharing") then
        cursor:set("on-usergw", "ugw_sharing", "shareInternet", "on")
        os.execute("/usr/sbin/on_usergateway_check shareInternet &")
    end

    if luci.http.formvalue("suspend") then
        cursor:set("on-usergw", "ugw_sharing", "blockSharing", luci.http.formvalue("suspend_time"))
        cursor:set("on-usergw", "ugw_sharing", "shareInternet", "off")
        os.execute("/usr/sbin/on_usergateway_check shareInternet &")
    end

    cursor:commit("on-usergw")
    cursor:unload("on-usergw")

    if luci.http.formvalue("checkWAN") then os.execute("/usr/sbin/on_usergateway_check checkWan &") end
    if luci.http.formvalue("checkMTU") then os.execute("/usr/sbin/on_usergateway_check checkMtu &") end
    
    if luci.http.formvalue("upload") then upload_file("ugw") end
	
	local download = luci.http.formvalue("download")
	if download then download_file("ugw", download) end
	
	local openssl = {}
	fill_openssl("on-usergw", openssl)
	if luci.http.formvalue("generate") then generate_csr("ugw", openssl) end
	
	local SYSROOT = os.getenv("LUCI_SYSROOT")
	if not SYSROOT then SYSROOT = "" end		-- SYSROOT is only used for local testing (make runhttpd in luci tree)
	local on_csr_exists = nixio.fs.access(SYSROOT.."/etc/openvpn/opennet_ugw/on_ugws.csr")
	local on_key_exists = nixio.fs.access(SYSROOT.."/etc/openvpn/opennet_ugw/on_ugws.key")
	local on_crt_exists = nixio.fs.access(SYSROOT.."/etc/openvpn/opennet_ugw/on_ugws.crt")
	local force_show_uploadfields = luci.http.formvalue("force_show_uploadfields")
	local force_show_generatefields = luci.http.formvalue("force_show_generatefields")
	
    local ugw_status = {}
	-- central gateway-IPs reachable over tap-devices
    ugw_status.centralips = luci.sys.exec("for gw in $(uci -q get on-usergw.@usergw[0].centralIP); do ip route get $gw | awk '{if ($5 ~ \"tap\") print $1}' ; done")
    local words
    ugw_status.centralips_no = 0
    for words in string.gfind(ugw_status.centralips, "[^%s]+") do ugw_status.centralips_no=ugw_status.centralips_no+1 end
    ugw_status.centralip_status = "error"
    if ugw_status.centralips_no >= 1 then ugw_status.centralip_status = "ok" end
    -- tunnel active
    local iterator, number = nixio.fs.glob("/tmp/opennet_ugw-*.txt")
    ugw_status.tunnel_active = (number >= 1)
    -- sharing possible
    ugw_status.usergateways_no = 0
    cursor:foreach ("on-usergw", "usergateway", function() ugw_status.usergateways_no = ugw_status.usergateways_no + 1 end)
    ugw_status.sharing_wan_ok = false
    ugw_status.sharing_possible = false
    local count = 1
    while count <= ugw_status.usergateways_no do
        local onusergw = cursor:get_all("on-usergw", "opennet_ugw"..count)
        if (onusergw.wan == "ok") then ugw_status.sharing_wan_ok = true end
        if (onusergw.wan == "ok" and onusergw.mtu == "ok") then
            ugw_status.sharing_possible = true
            break
        end
        count = count + 1
    end
    -- sharing enabled
    ugw_status.sharing_enabled = (cursor:get("on-usergw", "ugw_sharing", "shareInternet") == "on")
    -- sharing blocked
	ugw_status.sharing_blocked = cursor:get("on-usergw", "ugw_sharing", "blockSharing")
	-- checkMTU or checkWAN running
	local returnVal = luci.sys.exec("ps | grep on_usergateway_check")
	ugw_status.checkWANMTUrunning = (string.match(returnVal, "checkMtu") or string.match(returnVal, "checkWan"))
	
	luci.template.render("opennet/on_usergw", {
		ugw_status=ugw_status, on_csr_exists=on_csr_exists,on_key_exists=on_key_exists, on_crt_exists=on_crt_exists,
		openssl=openssl, force_show_uploadfields=force_show_uploadfields, force_show_generatefields=force_show_generatefields
		})
end
