#!/bin/sh
#
# Opennet Firmware
# 
# Copyright 2010 Rene Ejury <opennet@absorb.it>
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#   http://www.apache.org/licenses/LICENSE-2.0
# 

# retrieve DEBUG-state
DEBUG=$(uci -q get on-core.defaults.debug)

. /etc/functions.sh

# newline
N="
"
$DEBUG && logger -t opennet_ugw_up.sh "starting for iface ${dev}"

local batch
# add new network to configuration (to be recognized by olsrd)
append batch "set network.on_${dev}=interface${N}"
append batch "set network.on_${dev}.proto=static${N}"
append batch "set network.on_${dev}.ifname=${dev}${N}"
append batch "set network.on_${dev}.netmask=${ifconfig_netmask}${N}"
append batch "set network.on_${dev}.ipaddr=${ifconfig_local}${N}"
append batch "set network.on_${dev}.defaultroute=0${N}"
append batch "set network.on_${dev}.peerdns=0${N}"

$DEBUG && logger -t opennet_ugw_up.sh "adding new network config for ${dev}"
        
echo "$batch${N}commit network" | uci batch

$DEBUG && logger -t opennet_ugw_up.sh "adding iterface ${dev} to config of firewall zone opennet"
uci -q set firewall.zone_opennet.network="$(uci -q get firewall.zone_opennet.network) on_${dev}"
uci commit firewall

# adding on_tapX (tapX) to firewall zone opennet
. /lib/firewall/uci_firewall.sh
addif on_${dev} ${dev} opennet

$DEBUG && logger -t opennet_ugw_up.sh "adding iterface ${dev} to config of olsrd, restarting olsrd"
uci -q set olsrd.@Interface[0].interface="$(uci -q get olsrd.@Interface[0].interface) on_${dev}"
uci commit olsrd

/etc/init.d/olsrd restart

filename=/tmp/opennet_ugw-${remote_1}.txt
echo $dev > $filename # a short message for the web frontend

$DEBUG && logger -t opennet_ugw_up.sh "finished for iface ${dev}"