#!/bin/sh
#
# Opennet Firmware
# 
# Copyright 2010 Rene Ejury <opennet@absorb.it>
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
# 	http://www.apache.org/licenses/LICENSE-2.0
# 

. /usr/bin/on-helper.sh

if [ -z "$(ip rule show | grep "lookup tun")" ];then
    mainprio=$(ip rule show | awk 'BEGIN{FS="[: ]"} /main/ {print $1; exit}')
	for network in "$(uci get -q firewall.zone_local.network)"; do
        networkprefix=$(get_network $network)
        [ -n "$networkprefix" ] && ip rule add from $networkprefix table tun prio $((mainprio+10))
    done
	ip rule add iif lo table tun prio $((mainprio+10))
fi

ip route flush table tun
#   prefer olsrd-routes for main and tunnel network
for network in $(uci get on-core.defaults.on_network); do
    ip route prepend throw $network table tun
done
ip route add default via $route_vpn_gateway table tun

# add device-specfic rules to relevant chains
iptables -A zone_on_tun_ACCEPT -i $dev -j ACCEPT
iptables -A zone_on_tun_ACCEPT -o $dev -j ACCEPT
iptables -A input_rule -i $dev -j input_on_tun

iptables -t nat -A POSTROUTING -o $dev -j zone_on_tun_nat
iptables -t nat -A zone_on_tun_nat -o $dev -j SNAT --to-source $ifconfig_local

echo "vpn-tunnel active" >/tmp/openvpn_msg.txt	# a short message for the web frontend
